<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('Vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");

$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    if (isset($shonupost['language'], $shonupost['random'], $shonupost['signature'], $shonupost['timestamp'])) {
        $language = mysqli_real_escape_string($conn, $shonupost['language']);
        $random = mysqli_real_escape_string($conn, $shonupost['random']);
        $signature = mysqli_real_escape_string($conn, $shonupost['signature']);
        $shonustr = '{"language":"' . $language . '","random":"' . $random . '"}';
        $shonusign = strtoupper(md5($shonustr));
        $dataBlock = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['dataBlock']));

        $query = "SELECT id FROM shonu_subjects WHERE akshinak = '$dataBlock' LIMIT 1";
        $result = mysqli_query($conn, $query);
        $row = mysqli_fetch_assoc($result);
        $id = $row['id'];
        $workOrderNo = time() . rand(1000, 9999);

        if (isset($shonupost['formId']) && $shonupost['formId'] == 14) {
            $formId = $shonupost['formId'];
            $depositOrderNo = '';
            $orderAmount = '';
            $textContent = '';
            $utr = '';
            $fileUpload = '';
            $imageUpload = '';
            $fileName = '';
            $imageName = ''; // FIX: initialized here

            foreach ($shonupost['formFields'] as $item) {
                if ($item['typeCode'] == 'DepositOrderNo') {
                    $depositOrderNo = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'OrderAmount') {
                    $orderAmount = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'TextContent') {
                    $textContent = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'UTR') {
                    $utr = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'FileUpload') {
                    $fileUpload = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'ImageUpload') {
                    $imageUpload = mysqli_real_escape_string($conn, $item['fieldValue']);
                }
            }

            $uploadDir = '../../uploads/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            if ($fileUpload) {
                $fileName = basename(parse_url($fileUpload, PHP_URL_PATH));
                $filePath = $uploadDir . $fileName;
                if (@file_put_contents($filePath, @file_get_contents($fileUpload)) === false) {
                    http_response_code(500);
                    echo json_encode(['code' => 17, 'msg' => 'Failed to download file', 'msgCode' => 17]);
                    exit;
                }
            }

            if ($imageUpload) {
                $imageName = basename(parse_url($imageUpload, PHP_URL_PATH));
                $imagePath = $uploadDir . $imageName;
                if (@file_put_contents($imagePath, @file_get_contents($imageUpload)) === false) {
                    http_response_code(500);
                    echo json_encode(['code' => 17, 'msg' => 'Failed to download image', 'msgCode' => 17]);
                    exit;
                }
            }

            $prob = 'Deposit Not Receive';
            $query = "INSERT INTO your_table (prob, userid, form_id, deposit_order_no, order_amount, text_content, utr, file_upload, image_upload, oid) 
                      VALUES ('$prob', '$id', '16', '$depositOrderNo', '$orderAmount', '$textContent', '$utr', '$fileName', '$imageName', '$workOrderNo')";

            if (mysqli_query($conn, $query)) {
                http_response_code(200);
                echo json_encode([
                    "data" => true,
                    "msgParameters" => null,
                    "code" => 0,
                    "msg" => "Succeed",
                    "msgCode" => 0
                ]);
            } else {
                http_response_code(500);
                echo json_encode(['code' => 15, 'msg' => 'Database error: ' . mysqli_error($conn), 'msgCode' => 15]);
            }

        } else if ($shonupost['formId'] == 16) {
            $ifsc = '';
            $bankAccountNumber = '';
            foreach ($shonupost['formFields'] as $item) {
                if ($item['typeCode'] == 'IFSC') {
                    $ifsc = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'BankAccountNumber') {
                    $bankAccountNumber = mysqli_real_escape_string($conn, $item['fieldValue']);
                }
            }

            $prob = 'IFSC Modification';
            $query = "INSERT INTO your_table (prob, deposit_order_no, userid, form_id, ifsc, bank_account_number) 
                      VALUES ('$prob', '$workOrderNo', '$id', '16', '$ifsc', '$bankAccountNumber')";

            if (mysqli_query($conn, $query)) {
                http_response_code(200);
                echo json_encode(["data" => true, "msgParameters" => null, "code" => 0, "msg" => "Succeed", "msgCode" => 0]);
            } else {
                http_response_code(500);
                echo json_encode(['code' => 15, 'msg' => 'Database error: ' . mysqli_error($conn), 'msgCode' => 15]);
            }

        } else if ($shonupost['formId'] == 75) {
            $longText = '';
            $fileUpload = '';
            $fileName = '';

            foreach ($shonupost['formFields'] as $item) {
                if ($item['typeCode'] == 'LongText') {
                    $longText = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'FileUpload') {
                    $fileUpload = mysqli_real_escape_string($conn, $item['fieldValue']);
                }
            }

            if ($fileUpload) {
                $fileName = basename(parse_url($fileUpload, PHP_URL_PATH));
                $filePath = '../../uploads/' . $fileName;
                if (!is_dir('../../uploads/')) mkdir('../../uploads/', 0777, true);
                if (@file_put_contents($filePath, @file_get_contents($fileUpload)) === false) {
                    http_response_code(500);
                    echo json_encode(['code' => 17, 'msg' => 'Failed to download file', 'msgCode' => 17]);
                    exit;
                }
            }

            $query = "INSERT INTO your_table (deposit_order_no, form_id, prob, userid, text_content, file_upload) 
                      VALUES ('$workOrderNo', '16', 'Game Problems', '$id', '$longText', '$fileName')";

            if (mysqli_query($conn, $query)) {
                http_response_code(200);
                echo json_encode(["data" => true, "msgParameters" => null, "code" => 0, "msg" => "Succeed", "msgCode" => 0]);
            } else {
                http_response_code(500);
                echo json_encode(['code' => 15, 'msg' => 'Database error: ' . mysqli_error($conn), 'msgCode' => 15]);
            }

        } else if ($shonupost['formId'] == 15) {
            $CardName = '';
            $bankAccountNumber = '';

            foreach ($shonupost['formFields'] as $item) {
                if ($item['typeCode'] == 'CardName') {
                    $CardName = preg_replace('/=\d+/', '', $item['fieldValue']);
                } elseif ($item['typeCode'] == 'BankAccountNumber') {
                    $bankAccountNumber = mysqli_real_escape_string($conn, $item['fieldValue']);
                }
            }

            $prob = 'Change bank name';
            $query = "INSERT INTO your_table (prob, deposit_order_no, userid, form_id, CardName, bank_account_number) 
                      VALUES ('$prob', '$workOrderNo', '$id', '16', '$CardName', '$bankAccountNumber')";

            if (mysqli_query($conn, $query)) {
                http_response_code(200);
                echo json_encode(["data" => true, "msgParameters" => null, "code" => 0, "msg" => "Succeed", "msgCode" => 0]);
            } else {
                http_response_code(500);
                echo json_encode(['code' => 15, 'msg' => 'Database error: ' . mysqli_error($conn), 'msgCode' => 15]);
            }

        } else if ($shonupost['formId'] == 25) {
            $longText = '';
            $fileUpload = '';
            $WithdrawAmount = '';
            $WithdrawOrderNo = '';
            $fileName = '';

            foreach ($shonupost['formFields'] as $item) {
                if ($item['typeCode'] == 'TextContent') {
                    $longText = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'FileUpload') {
                    $fileUpload = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'WithdrawAmount') {
                    $WithdrawAmount = mysqli_real_escape_string($conn, $item['fieldValue']);
                } elseif ($item['typeCode'] == 'WithdrawOrderNo') {
                    $WithdrawOrderNo = mysqli_real_escape_string($conn, $item['fieldValue']);
                }
            }

            if ($fileUpload) {
                $fileName = basename(parse_url($fileUpload, PHP_URL_PATH));
                $filePath = '../../uploads/' . $fileName;
                if (!is_dir('../../uploads/')) mkdir('../../uploads/', 0777, true);
                if (@file_put_contents($filePath, @file_get_contents($fileUpload)) === false) {
                    http_response_code(500);
                    echo json_encode(['code' => 17, 'msg' => 'Failed to download file', 'msgCode' => 17]);
                    exit;
                }
            }

            $query = "INSERT INTO your_table (order_amount, deposit_order_no, form_id, prob, userid, text_content, file_upload) 
                      VALUES ('$WithdrawAmount', '$WithdrawOrderNo', '16', 'Withdrawal problem', '$id', '$longText', '$fileName')";

            if (mysqli_query($conn, $query)) {
                http_response_code(200);
                echo json_encode(["data" => true, "msgParameters" => null, "code" => 0, "msg" => "Succeed", "msgCode" => 0]);
            } else {
                http_response_code(500);
                echo json_encode(['code' => 15, 'msg' => 'Database error: ' . mysqli_error($conn), 'msgCode' => 15]);
            }

        } else {
            http_response_code(400);
            echo json_encode(['code' => 16, 'msg' => 'Invalid formId', 'msgCode' => 16]);
        }
    } else {
        http_response_code(403);
        echo json_encode(['code' => 13, 'msg' => 'Invalid signature', 'msgCode' => 13]);
    }
} else {
    http_response_code(405);
    echo json_encode($res);
}
