@extends($activeTemplate.'layouts.master')
@section('content')
@if($isHoliday)
<script>
    "use strict"
    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function () {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            var days = `<span>${days}d</span>`;
            var hours = `<span>${hours}h</span>`;
            var minutes = `<span>${minutes}m</span>`;
            var seconds = `<span>${seconds}s</span>`;
            document.getElementById(elementId).innerHTML = days +' '+ hours + " " + minutes + " " + seconds;
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "COMPLETE";
            }
            tms--;
        }, 1000);
    }
</script>

@push('style')
    <style>
        .counter-area span {
            font-size: 45px;
            font-weight: bold;
            margin: 0px 7px;
            font-family: 'Lora', serif;
        }
        .navbar {
    width: 100%;
    max-width: 750px;
    background: #ff6201;
    height: 50px;
    line-height: 50px;
    align-items: center;
    color: #FFFFFF;
    border-bottom: 1px solid #fff;
    justify-content: center;
    position: fixed;
    font-size: 16px;
    z-index: 999;
}
    </style>
@endpush

@endif
    @if($isHoliday && !$general->holiday_withdraw)
            <div class="text-center counter-area mt-5">
                <h3 class="text--base">@lang('Next Working Day')</h3>
                <div id="counter"></div>
                <script>createCountDown('counter', {{\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds()}});</script>
            </div>
            @else

    
<style>
    .navbar {
    width: 100%;
    max-width: 750px;
    background: #ff6201;
    height: 50px;
    line-height: 50px;
    align-items: center;
    color: #FFFFFF;
    border-bottom: 1px solid #fff;
    justify-content: center;
    position: fixed;
    font-size: 16px;
    z-index: 999;
}
.balance-total {
    width: 100%;
    box-shadow: 0 1px 8px #ccc;
    background: #ff6201;
}
.recharge-btn button {
    width: 100%;
    padding: 12px 0;
    -webkit-border-radius: 5px;
    border-radius: 5px;
    -moz-border-radius: 5px;
    color: #fff;
    font-size: 16px;
    font-weight: 600;
    border: #ff6201;
    background: #ff6201;
    cursor: pointer;
}
.recharge-tit {
    color: #000000;
    font-size: 14px;
    font-weight: 600;
    padding: 0 5px;
    height: 30px;
    line-height: 30px;
}
.recharge-amount span, .recharge-amount input {
    height: 36px;
    color: #000000;
    line-height: 36px;
    background: #f7f7f7;
}
</style>

<body class="page-bg">
<div class="navbar">
    <a href="{{route ('user.home')}}" class="navbar-left">
        <i class="icon iconfont icon-angleleft"></i>
    </a>
    <div class="navbar-title">Withdraw</div>
    <a href="{{route ('user.withdraw.history')}}" class="navbar-right">record</a>
</div>
<div class="information-navbar navbar-head">
    <div class="recharge-con">
        <div class="balance-total">
            <div class="balance-info">
                            <span>
                   {{ showAmount(auth()->user()->interest_wallet) }} {{ $general->cur_text }}
                    <font></font>
                </span>
                <span>Current Balance</span>
            </div>
            <dl>
                <dd>
       
                    
                    <span><span class="min fw-bold">0</span>{{__($general->cur_text)}}</span>
                    <span>Minmum Withdraw</span>
                </dd>
                <dd>
                    <span><span class="max fw-bold">0</span>{{__($general->cur_text)}}</span>
                    <span>Maxmium Withdraw</span>
                </dd>
            </dl>
        </div>
             <form action="{{route('user.withdraw.money')}}" method="post">
                        @csrf
        
        
       
        </div>
        <div class="recharge-info">
            <div class="recharge-tit">Withdraw Amount</div>
            <div class="recharge-amount">
    
                
                <input type="number" step="any"  placeholder="please enter recharge amount..."     name="amount"  value="{{ old('amount') }}" autocomplete="off" required>
                
                
                
                <span>{{__($general->cur_text)}}</span>
            </div>
            <div class="space-10"></div>
            <div class="recharge-tit">Withdraw Method</div>
                  <div class="recharge-amount">
                      
                      
                      
                               <select  style="width: 100%; height: 50px;" class="login-input-input"    name="method_code" required>
                                        <option value="">@lang('Select One')</option>
                                              @foreach($withdrawMethod as $data)
                                    <option value="{{ $data->id }}" data-resource="{{$data}}">  {{__($data->name)}}</option>
                                @endforeach
                                    </select>
        
                <span></span>
            </div>
        </div>
        </div>
        <div class="space-14"></div>
        <div class="recharge-btn">
            <button type="submit">Withdraw</button>
        
        </div>
      
        <div class="space-1500"></div>
        <div class="information-text">
            
            
                    </div>
    </div>
</div>

    <h1>‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ ‎ </h1>


<div class="hide recharging"></div>

</body>
</html>
                
                
                
        <div class="form-group" style="display:none;" >
                    
                        <div class="mt-3 preview-details d-none">
                            <ul class="list-group text-center">
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>@lang('Limit')</span>
                                    <span><span class="min fw-bold">0</span> {{__($general->cur_text)}} - <span class="max fw-bold">0</span> {{__($general->cur_text)}}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>@lang('Charge')</span>
                                    <span><span class="charge fw-bold">0</span> {{__($general->cur_text)}}</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between">
                                    <span>@lang('Receivable')</span> <span><span class="receivable fw-bold"> 0</span> {{__($general->cur_text)}} </span>
                                </li>
                                <li class="list-group-item d-none justify-content-between rate-element">

                                </li>
                                <li class="list-group-item d-none justify-content-between in-site-cur">
                                    <span>@lang('In') <span class="base-currency"></span></span>
                                    <strong class="final_amo">0</strong>
                                </li>
                            </ul>
                        </div>
                        <button type="submit" class="btn btn--base w-100 mt-3">@lang('Submit')</button>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    (function ($) {
        "use strict";
        $('select[name=method_code]').change(function(){
            if(!$('select[name=method_code]').val()){
                $('.preview-details').addClass('d-none');
                return false;
            }
            var resource = $('select[name=method_code] option:selected').data('resource');
            var fixed_charge = parseFloat(resource.fixed_charge);
            var percent_charge = parseFloat(resource.percent_charge);
            var rate = parseFloat(resource.rate)
            var toFixedDigit = 2;
            $('.min').text(parseFloat(resource.min_limit).toFixed(2));
            $('.max').text(parseFloat(resource.max_limit).toFixed(2));
            var amount = parseFloat($('input[name=amount]').val());
            if (!amount) {
                amount = 0;
            }
            if(amount <= 0){
                $('.preview-details').addClass('d-none');
                return false;
            }
            $('.preview-details').removeClass('d-none');

            var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
            $('.charge').text(charge);
            if (resource.currency != '{{ $general->cur_text }}') {
                var rateElement = `<span>@lang('Conversion Rate')</span> <span class="fw-bold">1 {{__($general->cur_text)}} = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span>`;
                $('.rate-element').html(rateElement);
                $('.rate-element').removeClass('d-none');
                $('.in-site-cur').removeClass('d-none');
                $('.rate-element').addClass('d-flex');
                $('.in-site-cur').addClass('d-flex');
            }else{
                $('.rate-element').html('')
                $('.rate-element').addClass('d-none');
                $('.in-site-cur').addClass('d-none');
                $('.rate-element').removeClass('d-flex');
                $('.in-site-cur').removeClass('d-flex');
            }
            var receivable = parseFloat((parseFloat(amount) - parseFloat(charge))).toFixed(2);
            $('.receivable').text(receivable);
            var final_amo = parseFloat(parseFloat(receivable)*rate).toFixed(toFixedDigit);
            $('.final_amo').text(final_amo);
            $('.base-currency').text(resource.currency);
            $('.method_currency').text(resource.currency);
            $('input[name=amount]').on('input');
        });
        $('input[name=amount]').on('input',function(){
            var data = $('select[name=method_code]').change();
            $('.amount').text(parseFloat($(this).val()).toFixed(2));
        });
    })(jQuery);
</script>
@endpush
