<?php
    $promotionCount = App\Models\PromotionTool::count();
?>

<header class="header">
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">
                <a class="site-logo site-title" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>" alt="site-logo"></a>
                <ul class="account-menu responsive-account-menu ms-3">
                    <li class="icon"><a href="<?php echo e(route('user.home')); ?>"><i class="las la-user"></i></a></li>
                </ul>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu ms-auto">
                        <li> <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a></li>
                        <li><a href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Investment'); ?></a></li>
                        <li class="menu_has_children"><a href="javascript:void(0)"><?php echo app('translator')->get('Deposit'); ?></a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.deposit.index')); ?>"><?php echo app('translator')->get('Deposit'); ?></a></li>
                                <li><a href="<?php echo e(route('user.withdraw')); ?>"><?php echo app('translator')->get('Withdraw'); ?></a></li>
                                <?php if($general->b_transfer): ?>
                                    <li><a href="<?php echo e(route('user.transfer.balance')); ?>"><?php echo app('translator')->get('Transfer Balance'); ?></a></li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(route('user.transactions')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
                            </ul>
                        </li>
                        <li><a href="<?php echo e(route('user.referrals')); ?>"><?php echo app('translator')->get('Referrals'); ?></a></li>
                        <?php if($general->promotional_tool && $promotionCount): ?>
                            <li><a href="<?php echo e(route('user.promotional.banner')); ?>"><?php echo app('translator')->get('Promotional Tool'); ?></a></li>
                        <?php endif; ?>
                        <li class="menu_has_children"><a href="javascript:void(0)"><?php echo app('translator')->get('Account'); ?></a>
                            <ul class="sub-menu">
                                <li><a href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile Setting'); ?></a></li>
                                <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
                                <li><a href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
                                <li><a href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Ticket'); ?></a></li>
                                <li><a href="<?php echo e(route('user.logout')); ?>"> <?php echo e(__('Logout')); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <div class="nav-right">
                        <ul class="account-menu ms-3">
                            <?php if(auth()->guard()->guest()): ?>
                                <li class="icon"><a href="<?php echo e(route('user.login')); ?>"><i class="las la-user"></i></a></li>
                            <?php else: ?>
                                <li class="icon"><a href="<?php echo e(route('user.home')); ?>"><i class="las la-user"></i></a></li>
                            <?php endif; ?>
                        </ul>
                        <?php if($general->language_switch): ?>
                            <select class="select d-inline-block w-auto ms-xl-3 langSel">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                    </div>
                </div>
            </nav>
        </div>
    </div><!-- header__bottom end -->
</header>
<!-- header-section end  -->
<?php /**PATH /home/u452099573/domains/alpha7x.com/public_html/core/resources/views/templates/bit_gold/partials/user_header.blade.php ENDPATH**/ ?>