<?php $__env->startSection('content'); ?>

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
.tooltip {
  position: relative;
  display: inline-block;
}

.tooltip .tooltiptext {
  visibility: hidden;
  width: 140px;
  background-color: #555;
  color: #fff;
  text-align: center;
  border-radius: 6px;
  padding: 5px;
  position: absolute;
  z-index: 1;
  bottom: 150%;
  left: 50%;
  margin-left: -75px;
  opacity: 0;
  transition: opacity 0.3s;
}

.tooltip .tooltiptext::after {
  content: "";
  position: absolute;
  top: 100%;
  left: 50%;
  margin-left: -5px;
  border-width: 5px;
  border-style: solid;
  border-color: #555 transparent transparent transparent;
}

.tooltip:hover .tooltiptext {
  visibility: visible;
  opacity: 1;
}
</style>
</head>
<body>

<div style="display:none;">
<input type="text" value="<?php echo e(route('home')); ?>?reference=<?php echo e(auth()->user()->username); ?>" id="myInput">
</div>




<script>
function myFunction() {
  var copyText = document.getElementById("myInput");
  copyText.select();
  copyText.setSelectionRange(0, 99999);
  navigator.clipboard.writeText(copyText.value);
  
  var tooltip = document.getElementById("myTooltip");
  tooltip.innerHTML = "Copied: " + copyText.value;
}

function outFunc() {
  var tooltip = document.getElementById("myTooltip");
  tooltip.innerHTML = "Copy to clipboard";
}
</script>
</body>
</html>



<?php
  $authUser = Auth::user();
  $balance = number_format($authUser->balance, 0, '.', '');
?>



<?php
    use App\Models\Transaction;
    $authUserId = Auth::id();
    $referralCommission = Transaction::where('user_id', $authUserId)
                                    ->where('remark', 'referral_commission')
                                    ->sum('amount');
    $formattedReferralCommission = number_format($referralCommission, 0, '.', '');
?>


<?php
    $authUserId = Auth::id();
    $ptcEarn = Transaction::where('user_id', $authUserId)
                            ->where('remark', 'ptc_earn')
                            ->sum('amount');
    $formattedPtcEarn = intval($ptcEarn);
?>


<?php
  use App\Models\Withdrawal;
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 2)
                          ->first();
  $finalAmount = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
?>

<?php
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 1)
                          ->first();
  $withdrawalAmount = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
  

?>

<?php
  $authUserId = Auth::id();
  $withdrawal = Withdrawal::where('user_id', $authUserId)
                          ->where('status', 3)
                          ->first();
  $withdrawalAmountre = $withdrawal ? number_format($withdrawal->final_amount, 0, '.', '') : 0;
  
$pageTitle = 'wallet';
?>

<div class="information-foot navbar-foot">
    <div class="invite-content">
        <div class="invite-main">
            <div class="invite-main-content">
                <div class="invite-dd invite-code">
                    <span>Invite Code</span>
                    <div class="invite-code-info copy"
                         data-clipboard-text="<?php echo e(route('home')); ?>?reference=<?php echo e(auth()->user()->username); ?>"><?php echo e(auth()->user()->username); ?></div>
                </div>
                <div class="invite-dd invite-qrcode">
                    <img src="<?php echo e(asset ('core/img/1.png')); ?>">
                </div>
            </div>
            
            <button onclick="myFunction()" onmouseout="outFunc()">
  <span class="tooltiptext" id="myTooltip">Copy Link</span>
  
  </button>
            <?php
  $authUser = Auth::user();
  $userCount = App\Models\User::where('ref_by', $authUser->id)->count();
?>
        </div>
        <div class="my-team">
            <ul>
                <li>
                    <span>     <?php echo e($userCount); ?></span>
                    <label>Invite</label>
                </li>
                <li>
                    <span><?php echo e($referralCommission); ?> <?php echo e($general->cur_text); ?></span>
                    <label>Team Income</label>
                </li>
            </ul>
        </div>
        <div class="team-head">
            <div class="team-tab">
                                    <a href="" class="active">
                        B（1）
                    </a>
                                                    <a href="">
                        C（0）
                    </a>
                                                    <a href="">
                        D（0）
                    </a>
                            </div>
        </div>
        <div class="team-option">
            



          <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
          
            <div class="card">
                <div class="card-body">
                    <div class="treeview-container">
                        <ul class="treeview">
                        <li class="items-expanded"> <?php echo e($user->fullname); ?> ( <?php echo e($user->username); ?> )
                                <?php echo $__env->make($activeTemplate.'partials.under_tree',['user'=>$user,'layer'=>0,'isFirst'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <link href="<?php echo e(asset('assets/global/css/jquery.treeView.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/global/js/jquery.treeView.js')); ?>"></script>
<script>
    (function($){
    "use strict"
        $('.treeview').treeView();
        $('.copyBoard').click(function(){
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);

                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/feeabarx/public_html/core/resources/views/templates/invester/user/referrals.blade.php ENDPATH**/ ?>