
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1.0">
    <title>ChickenRoad Game</title>
    <meta name="description" content="Chicken Road Game - Safe from cars and Win Big!">

    <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@500;700&display=swap">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: #0d0d0d;
            color: white;
            overflow-x: hidden;
        }
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
            background-color: #1a1a1d;
        }
        .logo img {
            width: 150px;
        }
        .lang-select {
            display: flex;
            align-items: center;
        }
        .lang-select img {
            width: 30px;
            margin-right: 10px;
        }
        .lang-select span {
            font-size: 18px;
            cursor: pointer;
        }

        /* Hero Section */
        .hero {
            height: 100vh;
            background-image: url('/img/frame.webp');
            background-size: cover;
            background-position: center;
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            flex-direction: column;
        }
        .hero img {
            max-width: 300px;
            margin-bottom: 20px;
        }
        .hero-content {
            z-index: 1;
        }
        .hero h1 {
            font-size: 48px;
            font-weight: 700;
            color: #f7b731;
            margin-bottom: 20px;
        }
        .hero p {
            font-size: 24px;
            margin-bottom: 40px;
        }
        .hero button {
            padding: 15px 30px;
            background-color: #f7b731;
            border: none;
            border-radius: 50px;
            font-size: 18px;
            color: #0c0c0e;
            cursor: pointer;
            transition: background-color 0.4s ease;
        }
        .hero button:hover {
            background-color: #e09323;
        }
        .hero-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            z-index: 0;
        }

        /* Promo Section */
        .promo {
            text-align: center;
            padding: 50px 0;
            background-color: #1a1a1d;
        }
        .promo h2 {
            font-size: 36px;
            margin-bottom: 20px;
            color: #f7b731;
        }
        .promo .promo-details {
            display: flex;
            justify-content: space-around;
            margin-top: 40px;
        }
        .promo-details div {
            font-size: 20px;
            text-align: center;
            background-color: #292929;
            padding: 20px;
            border-radius: 10px;
            color: white;
            width: 30%;
        }
        .promo-details div p {
            font-size: 18px;
        }
        .promo-details div strong {
            font-size: 24px;
            margin-bottom: 10px;
            display: block;
        }
        /* Adding some emojis for fun */
        .promo-details div:nth-child(1) {
            border: 2px solid #f7b731;
        }
        .promo-details div:nth-child(1) strong:before {
            content: '🐔 ';
        }
        .promo-details div:nth-child(2) {
            border: 2px solid #e67e22;
        }
        .promo-details div:nth-child(2) strong:before {
            content: '💰 ';
        }
        .promo-details div:nth-child(3) {
            border: 2px solid #27ae60;
        }
        .promo-details div:nth-child(3) strong:before {
            content: '🎉 ';
        }

        /* Footer */
        .footer {
            padding: 40px;
            background-color: #0d0d0d;
            color: #f7b731;
            text-align: center;
        }
        .footer p {
            margin-bottom: 15px;
            font-size: 18px;
        }
        .footer a {
            color: #f7b731;
            text-decoration: none;
            font-weight: 500;
        }
        .footer a:hover {
            text-decoration: underline;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 32px;
            }
            .hero p {
                font-size: 18px;
            }
            .promo h2 {
                font-size: 28px;
            }
            .promo .promo-details {
                flex-direction: column;
                gap: 20px;
            }
            .promo-details div {
                width: 80%;
                margin: 0 auto;
            }
        }
    </style>
</head>

<body>

    <!-- Header Section -->
    <header class="header">
        <div class="logo">
            <a href="#"><img src="/img/logo_head.png" alt="Aviator Game Logo"></a>
        </div>
        <div class="lang-select">
            <img src="https://origin-r2.ibbf55-resources.com/webStaticIB/promo/aviator_reg/img/flag/ind.svg" alt="English">
            <span>EN</span>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-overlay"></div>
        <div class="hero-content">
            <!-- New Image Above the Heading -->
            <img src="/img/logo.png" alt="Chicken Image">
            
            <h1>Live Chicken and Win Big!</h1>
            <p>One road, infinite danger, unlimited fun. <span style="color: #f7b731;">Get your chicken ready</span> — the traffic won’t stop!</p>
            <button onclick="window.location.href='/login'">Play Now</button>
        </div>
    </section>

    <!-- Promo Section -->
    <section class="promo">
        <h2>How to Get Started</h2>
        <div class="promo-details">
            <div>
                <strong>1. Sign Up</strong>
                <p>Create your chicken avatar and enter the road zone.</p>
            </div>
            <div>
                <strong>2. Collect & Upgrade</strong>
                <p>Grab coins, unlock power-ups, and give your chicken some serious swag.</p>
            </div>
            <div>
                <strong>3. Dodge & Conquer</strong>
                <p>Tap, slide, and jump your way to high scores and real rewards!</p>
            </div>
        </div>
    </section>

    <!-- Footer Section -->
    <footer class="footer">
        <p>&copy; 2025 Chicken Road Game. All rights reserved.</p>
        <p><a href="#">Terms of Service</a> | <a href="#">Privacy Policy</a></p>
    </footer>

</body>

</html>
