<?php
session_start();

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: login");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>chicken road - Games</title>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Roboto', sans-serif;
      background-color: #0d0d0d;
      color: #fff;
    }

    .slider-container {
      position: relative;
      overflow: hidden;
      max-height: 400px;
    }

    .slider-container img {
      width: 100%;
      height: auto;
      display: none;
      transition: opacity 1s ease-in-out;
    }

    .slider-container img.active {
      display: block;
    }

    .game-title {
      text-align: center;
      color: #f7b731;
      font-size: 2rem;
      font-weight: 700;
      margin: 40px 20px 20px;
    }

    .game-section {
      display: flex;
      flex-wrap: wrap;
      justify-content: center;
      gap: 20px;
      padding: 20px;
    }

    .game-box {
      background: linear-gradient(135deg, #111112, #29212f);
      border-radius: 20px;
      padding: 15px;
      text-align: center;
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.2);
      max-width: 300px;
      width: 100%;
      flex: 1 1 300px;
    }

    .game-box img {
      width: 100%;
      border-radius: 15px;
      margin-bottom: 15px;
      height: auto;
      object-fit: cover;
    }

    .play-btn {
      background-color: #f7b731;
      color: #1c0c45;
      padding: 12px 30px;
      border-radius: 50px;
      font-size: 1rem;
      font-weight: bold;
      text-transform: uppercase;
      text-decoration: none;
      transition: background-color 0.3s ease, transform 0.3s ease;
      display: inline-block;
    }

    .play-btn:hover {
      background-color: #e09323;
      transform: translateY(-3px);
    }

    .promo-section {
            padding: 50px 20px;
            background-color: #1f1f1f;
        }
        .promo-slider-container {
            display: flex;
            overflow-x: auto;
            scroll-behavior: smooth;
        }
        .promo-slide {
            min-width: 300px;
            margin-right: 20px;
            background-color: #333;
            background-size: cover;
            background-position: center;
            border-radius: 16px;
            padding: 20px;
            color: #fff;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .promo-slide h3 {
            font-size: 1.8em;
            margin-bottom: 10px;
        }
        .promo-slide p {
            font-size: 1em;
            margin-bottom: 15px;
        }
        .promo-slide button {
            background-color: transparent;
            border: 1px solid #fff;
            color: #fff;
            padding: 10px;
            cursor: pointer;
            border-radius: 8px;
        }
        .promo-slide button:hover {
            background-color: rgba(255, 255, 255, 0.2);
        }
        .promo-all-link {
            text-align: center;
            display: block;
            margin-top: 20px;
            color: #f39c12;
            font-size: 1.1em;
            text-decoration: underline;
        }

    footer {
      background-color: #1f1f1f;
      padding: 20px;
      text-align: center;
    }

    footer p {
      color: #aaa;
      font-size: 0.9em;
    }

    @media (max-width: 768px) {
      .game-title {
        font-size: 1.5rem;
      }
      .promo-slide {
        min-width: 250px;
      }
    }
  </style>
</head>
<body>

<?php include 'include/headernew.php'?>

<!-- Slider -->
<div class="slider-container">
  <img src="/img/b1.gif" class="active" alt="Slider 1">
  <img src="/img/b2.gif" alt="Slider 2">
  <img src="/img/b3.gif" alt="Slider 3">
</div>

<!-- Game Section -->
<h2 class="game-title">Start Playing Now – It’s Totally Egg-citing!</h2>
<section class="game-section">
  <div class="game-box">
    <img src="/img/chicken_road.png" alt="Chicken Road">
    <a href="/api/chicken_road.php" class="play-btn">Play Now</a>
  </div>

  <div class="game-box">
    <img src="/img/chicken_road_2.png" alt="Chicken Road 2">
    <a href="/api/chicken_road_2.php" class="play-btn">Play Now</a>
  </div>

  <div class="game-box">
    <img src="/img/penality.png" alt="Penalty">
    <a href="/api/penalty.php" class="play-btn">Play Now</a>
  </div>
</section>

<!-- Promo Section with Slider -->
<section class="promo-section">
    <h2 style="text-align:center; margin-bottom: 20px; font-size: 2em;">Latest Promotions</h2>
    <div class="promo-slider-container">
        <div class="promo-slide" style="background-image: url('https://static.ibbf55-resources.com/ContentIB/Banners/Welcome/996_new_customers.jpg');">
            <h3>Bonuses for New Clients</h3>
            <p>Start playing and get bonuses for every deposit.</p>
            <button>Learn More</button>
        </div>
        <div class="promo-slide" style="background-image: url('https://static.ibbf55-resources.com/ContentIB/Promo/CRM_Promo/New_Casino_Welcome_150_200FS/890h320.png');">
            <h3>Casino Welcome Bonus</h3>
            <p>150% + 200 FS for your first deposit.</p>
            <button>Learn More</button>
        </div>
        <div class="promo-slide" style="background-image: url('telegram-back.png');">
            <h3>Join telegram channel</h3>
            <p>Get free prediction by joining the telegram channel.</p>
            <button>Learn More</button>
        </div>
    </div>
</section>

<!-- Footer -->
<footer>
  <p>&copy; 2024 chicken road. All rights reserved.</p>
</footer>

<!-- JavaScript for slider -->
<script>
  const slides = document.querySelectorAll('.slider-container img');
  let currentSlide = 0;

  function showSlide(index) {
    slides.forEach((img, i) => {
      img.classList.toggle('active', i === index);
    });
  }

  function nextSlide() {
    currentSlide = (currentSlide + 1) % slides.length;
    showSlide(currentSlide);
  }

  setInterval(nextSlide, 5000); // Auto-slide every 5 seconds
</script>
</body>
</html>
