<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

$configFile = __DIR__ . '/config.php'; // go up one level
include($configFile);

// Get current values from config
$upi_id = $config['upi_id'] ?? '';
$qr_file = '../images/' . ($config['qr_code_filename'] ?? 'default.jpg'); // for preview

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $imagesFolder = dirname(__DIR__) . '/images/'; // absolute path to /images/

    if (!file_exists($imagesFolder)) {
        mkdir($imagesFolder, 0777, true);
    }

    // Handle image upload
    if (isset($_FILES['qr_image']) && $_FILES['qr_image']['error'] === 0) {
        $ext = pathinfo($_FILES['qr_image']['name'], PATHINFO_EXTENSION);
        $filename = 'qr_' . time() . '.' . $ext;
        $fullPath = $imagesFolder . $filename;
        move_uploaded_file($_FILES['qr_image']['tmp_name'], $fullPath);
        $qr_file = '../images/' . $filename;
        $config['qr_code_filename'] = $filename;
    }

    // Handle UPI ID update
    if (isset($_POST['upi_id'])) {
        $config['upi_id'] = trim($_POST['upi_id']);
    }

    // Update config file
    $newConfig = "<?php\n// config.php\n\$config = " . var_export($config, true) . ";\n?>";
    file_put_contents($configFile, $newConfig);

    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>QR & UPI Manager</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f0f2f5;
            padding: 40px;
        }
        .container {
            max-width: 500px;
            margin: auto;
            background: #fff;
            padding: 30px;
            border-radius: 14px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }
        label {
            font-weight: bold;
            display: block;
            margin-top: 15px;
        }
        input[type="text"], input[type="file"] {
            width: 100%;
            padding: 12px;
            margin-top: 8px;
            border-radius: 8px;
            border: 1px solid #ccc;
        }
        img.preview {
            max-width: 100%;
            max-height: 250px;
            margin-top: 15px;
            border-radius: 8px;
        }
        .btn {
            margin-top: 25px;
            width: 100%;
            padding: 14px;
            background: #007bff;
            color: white;
            font-size: 16px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background 0.2s ease;
        }
        .btn:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>QR & UPI Settings</h2>
    <form method="POST" enctype="multipart/form-data">
        <label for="qr_image">Upload QR Code</label>
        <input type="file" name="qr_image" id="qr_image" accept="image/*">
        <img src="<?= htmlspecialchars($qr_file) ?>" alt="QR Code" class="preview">

        <label for="upi_id">UPI ID</label>
        <input type="text" name="upi_id" id="upi_id" value="<?= htmlspecialchars($upi_id) ?>" required>

        <button class="btn" type="submit">Save</button>
    </form>
</div>
</body>
</html>
