<?php
$auth_password = "1234567890"; // 

session_start();

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Login logic
if (!isset($_SESSION['loggedin'])) {
    if (isset($_POST['password']) && $_POST['password'] === $auth_password) {
        $_SESSION['loggedin'] = true;
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $login_error = isset($_POST['password']) ? 'Invalid password' : '';
        echo '<!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>File Manager Login</title>
            <style>
                * {
                    margin: 0;
                    padding: 0;
                    box-sizing: border-box;
                    font-family: \'Segoe UI\', Tahoma, Geneva, Verdana, sans-serif;
                }
                
                body {
                    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                    height: 100vh;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    padding: 20px;
                }
                
                .login-container {
                    background: rgba(255, 255, 255, 0.9);
                    border-radius: 12px;
                    box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
                    width: 100%;
                    max-width: 400px;
                    padding: 40px;
                    text-align: center;
                    backdrop-filter: blur(10px);
                }
                
                .logo {
                    font-size: 48px;
                    margin-bottom: 20px;
                    color: #764ba2;
                }
                
                .login-title {
                    font-size: 28px;
                    color: #333;
                    margin-bottom: 30px;
                    font-weight: 600;
                }
                
                .login-form {
                    display: flex;
                    flex-direction: column;
                    gap: 20px;
                }
                
                .input-group {
                    position: relative;
                }
                
                .input-group input {
                    width: 100%;
                    padding: 14px 20px 14px 50px;
                    border: 2px solid #e1e1e1;
                    border-radius: 50px;
                    font-size: 16px;
                    transition: all 0.3s ease;
                    outline: none;
                }
                
                .input-group input:focus {
                    border-color: #764ba2;
                    box-shadow: 0 0 0 3px rgba(118, 75, 162, 0.2);
                }
                
                .input-group i {
                    position: absolute;
                    left: 20px;
                    top: 50%;
                    transform: translateY(-50%);
                    color: #764ba2;
                    font-size: 20px;
                }
                
                .login-btn {
                    background: linear-gradient(to right, #667eea, #764ba2);
                    color: white;
                    border: none;
                    padding: 14px;
                    border-radius: 50px;
                    font-size: 16px;
                    font-weight: 600;
                    cursor: pointer;
                    transition: all 0.3s ease;
                    letter-spacing: 1px;
                }
                
                .login-btn:hover {
                    transform: translateY(-2px);
                    box-shadow: 0 7px 14px rgba(118, 75, 162, 0.3);
                }
                
                .login-error {
                    color: #e74c3c;
                    margin-top: 10px;
                    font-size: 14px;
                    height: 20px;
                }
                
                .footer {
                    margin-top: 30px;
                    color: #777;
                    font-size: 14px;
                }
            </style>
        </head>
        <body>
            <div class="login-container">
                <div class="logo">🔐</div>
                <h1 class="login-title">File Manager Login</h1>
                <form method="POST" class="login-form">
                    <div class="input-group">
                        <i>🔒</i>
                        <input type="password" name="password" placeholder="Enter your password" required>
                    </div>
                    <button type="submit" class="login-btn">Login</button>
                    <div class="login-error">'.$login_error.'</div>
                </form>
                <div class="footer">Secure File Management System</div>
            </div>
        </body>
        </html>';
        exit;
    }
}

// File manager starts here
$dir = isset($_GET['dir']) ? $_GET['dir'] : '.';
$files = scandir($dir);
$parent_dir = dirname($dir);

// Handle folder creation
if (isset($_POST['new_folder']) && !empty($_POST['folder_name'])) {
    $new_folder = $dir . '/' . $_POST['folder_name'];
    if (!file_exists($new_folder)) {
        mkdir($new_folder);
    }
}

// Handle file upload
if (isset($_FILES['uploaded_file'])) {
    $target_file = $dir . '/' . basename($_FILES['uploaded_file']['name']);
    if (move_uploaded_file($_FILES['uploaded_file']['tmp_name'], $target_file)) {
        $upload_success = true;
    }
}

// Handle file deletion
if (isset($_GET['delete'])) {
    $file_to_delete = $_GET['delete'];
    if (file_exists($file_to_delete)) {
        if (is_dir($file_to_delete)) {
            rmdir($file_to_delete);
        } else {
            unlink($file_to_delete);
        }
        header("Location: ?dir=" . dirname($file_to_delete));
        exit;
    }
}

// Output the file manager interface
echo '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Professional File Manager</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #7209b7;
            --light: #f8f9fa;
            --dark: #212529;
            --success: #4cc9f0;
            --danger: #f72585;
            --warning: #f8961e;
            --gray: #6c757d;
            --light-gray: #e9ecef;
            --border-radius: 8px;
            --box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: \'Segoe UI\', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f0f2f5;
            color: var(--dark);
            line-height: 1.6;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        /* Header styles */
        header {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 20px;
            border-radius: var(--border-radius);
            margin-bottom: 25px;
            box-shadow: var(--box-shadow);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header-left h1 {
            font-size: 24px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .header-right {
            display: flex;
            gap: 15px;
        }
        
        .btn {
            padding: 10px 18px;
            border-radius: var(--border-radius);
            border: none;
            font-weight: 600;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: var(--transition);
        }
        
        .btn-primary {
            background-color: var(--primary);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
        }
        
        .btn-danger {
            background-color: var(--danger);
            color: white;
        }
        
        .btn-danger:hover {
            background-color: #e01e6e;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background-color: var(--success);
            color: white;
        }
        
        .btn-success:hover {
            background-color: #3ab4d4;
            transform: translateY(-2px);
        }
        
        /* Breadcrumb */
        .breadcrumb {
            background-color: white;
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 20px;
            box-shadow: var(--box-shadow);
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            align-items: center;
        }
        
        .breadcrumb a {
            color: var(--primary);
            text-decoration: none;
            transition: var(--transition);
        }
        
        .breadcrumb a:hover {
            text-decoration: underline;
        }
        
        .breadcrumb span {
            color: var(--gray);
        }
        
        .breadcrumb i {
            font-size: 12px;
            color: var(--gray);
        }
        
        /* Actions */
        .actions {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 20px;
        }
        
        .action-card {
            background-color: white;
            border-radius: var(--border-radius);
            padding: 20px;
            flex: 1;
            min-width: 250px;
            box-shadow: var(--box-shadow);
        }
        
        .action-card h3 {
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
            color: var(--primary);
            font-size: 18px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }
        
        .form-control {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-size: 16px;
            transition: var(--transition);
        }
        
        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
            outline: none;
        }
        
        /* File list */
        .file-list {
            background-color: white;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--box-shadow);
            margin-bottom: 30px;
        }
        
        .file-list-header {
            display: grid;
            grid-template-columns: 3fr 1fr 1fr 1fr 100px;
            padding: 15px 20px;
            background-color: var(--light);
            font-weight: 600;
            border-bottom: 1px solid var(--light-gray);
        }
        
        .file-item {
            display: grid;
            grid-template-columns: 3fr 1fr 1fr 1fr 100px;
            padding: 15px 20px;
            border-bottom: 1px solid var(--light-gray);
            transition: var(--transition);
        }
        
        .file-item:hover {
            background-color: #f8f9ff;
        }
        
        .file-item:last-child {
            border-bottom: none;
        }
        
        .file-name {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .file-icon {
            width: 24px;
            text-align: center;
        }
        
        .file-actions {
            display: flex;
            gap: 10px;
        }
        
        .file-action {
            color: var(--gray);
            cursor: pointer;
            transition: var(--transition);
        }
        
        .file-action:hover {
            color: var(--primary);
        }
        
        .file-action.delete:hover {
            color: var(--danger);
        }
        
        /* Editor */
        .editor-container {
            background-color: white;
            border-radius: var(--border-radius);
            padding: 25px;
            box-shadow: var(--box-shadow);
            margin-top: 20px;
        }
        
        .editor-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--light-gray);
        }
        
        .editor-title {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 20px;
        }
        
        textarea {
            width: 100%;
            height: 400px;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-family: monospace;
            font-size: 14px;
            line-height: 1.5;
            resize: vertical;
            transition: var(--transition);
        }
        
        textarea:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
            outline: none;
        }
        
        .notification {
            padding: 15px;
            border-radius: var(--border-radius);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .notification.success {
            background-color: rgba(76, 201, 240, 0.2);
            border: 1px solid var(--success);
        }
        
        .notification.error {
            background-color: rgba(247, 37, 133, 0.1);
            border: 1px solid var(--danger);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .file-list-header, .file-item {
                grid-template-columns: 1fr 1fr;
            }
            
            .file-size, .file-modified {
                display: none;
            }
            
            .actions {
                flex-direction: column;
            }
            
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .header-right {
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="header-left">
                <h1><i class="fas fa-folder-open"></i> Professional File Manager</h1>
            </div>
            <div class="header-right">
                <a href="?dir='.$dir.'" class="btn btn-success"><i class="fas fa-sync-alt"></i> Refresh</a>
                <a href="?logout" class="btn btn-danger"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </div>
        </header>
        
        <div class="breadcrumb">
            <a href="?dir=."><i class="fas fa-home"></i> Home</a>
            <i class="fas fa-chevron-right"></i>';
            
// Generate breadcrumb links
$breadcrumbs = [];
$current_path = '';
$parts = explode('/', $dir);

foreach ($parts as $part) {
    if ($part === '' || $part === '.') continue;
    $current_path .= $current_path ? '/' . $part : $part;
    $breadcrumbs[] = '<a href="?dir='.$current_path.'">'.$part.'</a>';
}

if (!empty($breadcrumbs)) {
    echo implode(' <i class="fas fa-chevron-right"></i> ', $breadcrumbs);
} else {
    echo '<span>Root Directory</span>';
}

echo '</div>';
        
// Display notifications
if (isset($upload_success) && $upload_success) {
    echo '<div class="notification success">
            <i class="fas fa-check-circle"></i> File uploaded successfully!
          </div>';
}

// Action cards
echo '<div class="actions">
        <div class="action-card">
            <h3><i class="fas fa-folder-plus"></i> Create New Folder</h3>
            <form method="POST">
                <div class="form-group">
                    <input type="text" name="folder_name" class="form-control" placeholder="Folder name" required>
                </div>
                <button type="submit" name="new_folder" class="btn btn-primary"><i class="fas fa-plus"></i> Create Folder</button>
            </form>
        </div>
        
        <div class="action-card">
            <h3><i class="fas fa-file-upload"></i> Upload File</h3>
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <input type="file" name="uploaded_file" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary"><i class="fas fa-upload"></i> Upload File</button>
            </form>
        </div>
    </div>';
        
// File list
echo '<div class="file-list">
        <div class="file-list-header">
            <div>Name</div>
            <div>Size</div>
            <div>Type</div>
            <div>Modified</div>
            <div>Actions</div>
        </div>';

// Parent directory link
if ($dir !== '.') {
    echo '<div class="file-item">
            <div class="file-name">
                <div class="file-icon"><i class="fas fa-level-up-alt"></i></div>
                <a href="?dir='.$parent_dir.'">.. (Parent Directory)</a>
            </div>
            <div>-</div>
            <div>Directory</div>
            <div>-</div>
            <div class="file-actions">
                <a href="?dir='.$parent_dir.'" title="Go up"><i class="fas fa-folder file-action"></i></a>
            </div>
        </div>';
}

foreach ($files as $file) {
    if ($file == '.' || $file == '..') continue;
    
    $path = $dir . '/' . $file;
    $is_dir = is_dir($path);
    $file_size = $is_dir ? '-' : formatSizeUnits(filesize($path));
    $file_type = $is_dir ? 'Directory' : pathinfo($file, PATHINFO_EXTENSION) . ' File';
    $file_modified = date("Y-m-d H:i", filemtime($path));
    
    $icon = $is_dir ? 'fa-folder text-warning' : 'fa-file text-primary';
    
    echo '<div class="file-item">
            <div class="file-name">
                <div class="file-icon"><i class="fas '.$icon.'"></i></div>
                '.($is_dir 
                    ? '<a href="?dir='.$path.'">'.$file.'</a>' 
                    : '<a href="'.$path.'" target="_blank">'.$file.'</a>')
            .'</div>
            <div>'.$file_size.'</div>
            <div>'.$file_type.'</div>
            <div>'.$file_modified.'</div>
            <div class="file-actions">';
            
    if (!$is_dir) {
        echo '<a href="?edit='.$path.'" title="Edit"><i class="fas fa-edit file-action"></i></a>';
    }
    
    echo '<a href="?delete='.$path.'" title="Delete" onclick="return confirm(\'Are you sure?\')"><i class="fas fa-trash-alt file-action delete"></i></a>
            </div>
        </div>';
}

echo '</div>'; // Close file-list

// File editor
if (isset($_GET['edit'])) {
    $file_to_edit = $_GET['edit'];
    $file_name = basename($file_to_edit);
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        file_put_contents($file_to_edit, $_POST['content']);
        echo '<div class="notification success">
                <i class="fas fa-check-circle"></i> File saved successfully!
              </div>';
    }
    
    $content = htmlspecialchars(file_get_contents($file_to_edit));
    
    echo '<div class="editor-container">
            <div class="editor-header">
                <div class="editor-title">
                    <i class="fas fa-file-code"></i> Editing: '.$file_name.'
                </div>
                <a href="?dir='.$dir.'" class="btn btn-primary"><i class="fas fa-arrow-left"></i> Back</a>
            </div>
            <form method="POST">
                <textarea name="content">'.$content.'</textarea>
                <div style="margin-top: 20px;">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Save Changes</button>
                </div>
            </form>
        </div>';
}

echo '</div> <!-- container -->
</body>
</html>';

// Helper function to format file sizes
function formatSizeUnits($bytes) {
    if ($bytes >= 1073741824) {
        $bytes = number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        $bytes = number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        $bytes = number_format($bytes / 1024, 2) . ' KB';
    } elseif ($bytes > 1) {
        $bytes = $bytes . ' bytes';
    } elseif ($bytes == 1) {
        $bytes = $bytes . ' byte';
    } else {
        $bytes = '0 bytes';
    }
    return $bytes;
}
?>